#  Package
#
package WebMod::Debug;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>  __PACKAGE__,
    VERSION_FROM			   =>  'VERSION.pm',

    PM					   =>  {
	'Debug.pm'			   =>  '$(INST_LIBDIR)/Debug.pm',
	'VERSION.pm'			   =>  '$(INST_LIBDIR)/Debug/VERSION.pm',
	'LICENSE'			   =>  '$(INST_LIBDIR)/Debug/LICENSE',
	'Constant.pm'			   =>  '$(INST_LIBDIR)/Debug/Constant.pm',
    },

    'dist'				   =>  {
	COMPRESS			   =>  'gzip -9f',
	SUFFIX				   =>  '.gz',
    },

    'depend'				   =>  {
	Makefile			   =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },


    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Debug.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

);


