#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebMod::Debug.
#
#  WebMod::Debug is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: Constant.pm,v 1.4 2003/11/03 02:45:22 aspeer Exp $

#
#  Webmod::Debug Constants file
#
package WebMod::Debug::Constant;;


#  Version Info, must be all one line for MakeMaker, CPAN.
#
$VERSION = eval { require WebMod::Debug::VERSION; do $INC{'WebMod/Debug/VERSION.pm'}};


#  Compiler Pragma
#
use strict qw(vars);
local $^W=0;


#  Exteral Modules. Use file spec for Win32 platforms
#
use File::Spec;


#  Constant
#
my %Constant=(

	D_NONE			=>	0,

	D_INIT			=>	2**0,

	D_METHOD		=>	2**1,

	D_SUB			=>	2**1,  #  Same as above

	D_UNDEF			=>	2**2,

	D_UNDEF			=>	2**3,

	D_UNDEF			=>	2**4,

	D_INFO			=>	2**4,

	D_INFO_0		=>	2**4,  #  Same as above

	D_INFO_1		=>	2**5,

	D_INFO_2		=>	2**6,

	D_INFO_3		=>	2**7,

	D_ALL			=>	(2**8)-1,
	
	D_DEFAULT		=>	(2**8)-1,  # Default log level
	#D_DEFAULT		=>	0,
	

);


#  Config hash
#
my %Config=(


	'linux'	=>	{

		FILE_CONFIG		=>	'/etc/debug.pm',

		%Constant,

	},


	'MSWin32'	=>	{

		FILE_CONFIG	=>	File::Spec->canonpath(
			join('/', $ENV{'windir'}, 'debug.pm')),

		%Constant

	}
);


#  Return set appropriate for OS or linux by
#  default
#
return $Config{$^O} ||= $Config{'linux'}
