# Build.PL
use strict; use warnings;
use Module::Build;

my $build = Module::Build->new(
	# look up Module::Build::API for the info!
	'dynamic_config'	=> 0,
	'module_name'		=> 'Test::Pod::Spelling::CommonMistakes',
	'license'		=> 'perl',

	'dist_abstract'		=> 'Checks POD for common spelling mistakes',
	'dist_author'		=> 'Apocalypse <APOCAL@cpan.org>',

	'create_packlist'	=> 1,
	'create_makefile_pl'	=> 'traditional',
	'create_readme'		=> 1,
	'create_license'	=> 1,
	'sign'			=> 0,

	'test_files'		=> 't/*.t',

	'requires'		=> {
		# Test stuff
		'Test::Builder'			=> '0.94',
		'Test::Pod'			=> '1.40',
		'Pod::Spell::CommonMistakes'	=> '0.01',

		# we need a recent perl
		'perl'				=> '5.008',
	},

	# include the standard stuff in META.yml
	'meta_merge'	=> {
		'resources'	=> {
			'license'	=> 'http://dev.perl.org/licenses/',
			'homepage'	=> 'http://search.cpan.org/dist/Test-Pod-Spelling-CommonMistakes',
			'bugtracker'	=> 'http://rt.cpan.org/NoAuth/Bugs.html?Dist=Test-Pod-Spelling-CommonMistakes',
			'repository'	=> 'http://github.com/apocalypse/perl-test-pod-spelling-commonmistakes',
		},
	},
);

# all done!
$build->create_build_script;
