# $Id: Makefile.PL,v 2.10 2001/05/07 07:17:33 ams Exp $
# Copyright 2001 Abhijit Menon-Sen <ams@wiw.org>

use Config;
use ExtUtils::MakeMaker;

print "Searching for uint16_t and uint32_t...\n";

($stdint = <<"TEST") =~ s/^\| {0,3}//gm;
|   #include <stdint.h>
|   int main(void) {
|       printf("%d%d", sizeof(uint16_t), sizeof(uint32_t));
|       return 0;
|   }
TEST
($inttypes = $stdint) =~ s/stdint/inttypes/;

if    (ftest($inttypes) eq "24") { $def = "#include <inttypes.h>"; }
elsif (ftest($stdint)   eq "24") { $def = "#include <stdint.h>";   }
else {
    foreach (qw(short int long)) {
        my $size = $Config{"${_}size"};
        $sixteen   ||= "unsigned $_" if ($size == 2);
        $thirtytwo ||= "unsigned $_" if ($size == 4);
    }
    $def = "typedef $sixteen uint16_t;\ntypedef $thirtytwo uint32_t;";
}

($text = <<"TYPES") =~ s/^\| {0,3}//gm;
|   /* Automatically generated by "perl Makefile.PL" */
|
|   #ifndef _PLATFORM_H_
|   #define _PLATFORM_H_
|
|   $def
|
|   #endif
TYPES

open(F, ">platform.h") || die "platform.h: $!\n";
print F $text;
close F;

sub MY::postamble { "tables.h: tab/tables.pl\n\tperl tab/tables.pl\n" }

WriteMakefile(
    NAME          => 'Crypt::Twofish',
    OBJECT        => 'Twofish.o _twofish.o',
    VERSION_FROM  => 'Twofish.pm',
    ABSTRACT_FROM => 'Twofish.pm',
    depend        => { '_twofish.c' => 'tables.h' },
);

# Compile and run a program to test for a particular feature.
sub ftest
{
    my $result = 0;

    open(F, ">ftest.c") || die "ftest.c: $!\n";
    print F $_[0];
    close F;

    unlink("ftest");
    if (system("$Config{cc} $Config{ccflags} -o ftest ftest.c") == 0) {
        $result = `./ftest`;
    }
    unlink("ftest", "ftest.c");

    return $result;
}
