use Evo 'Test::More; Evo::Internal::Exception';
use Evo -Class::Gen::XS, -Class::Meta, 'Scalar::Util reftype';

sub parse { Evo::Class::Meta->parse_attr(@_) }

#sub like      { } sub isa_ok    { } sub is_deeply { } sub is        { }
#do {

GEN_ATTR: {
  my $check = sub {1};
  my $noop  = sub {2};
  my $gen   = Evo::Class::Gen::XS->new;

  # req
  $gen->gen_attr(foo => parse(required => 1));
  is_deeply $gen->to_array, [{key => 'foo', rtype => 'required'}];

  # def ro check
  $gen->gen_attr(foo => parse(is => 'ro', default => undef, check => $check));
  is_deeply $gen->to_array, [{ro => 1, key => 'foo', rtype => 'default', rvalue => undef,
      check => $check}];

  $gen->gen_attr(foo => parse(lazy => $noop));
  is_deeply $gen->to_array, [{key => 'foo', rtype => 'lazy', rvalue => $noop}];

  $gen->gen_attr(foo => parse());
  is_deeply $gen->to_array, [{key => 'foo', rtype => 'relaxed'}];
}

GEN_INIT: {
  my $gen  = Evo::Class::Gen::XS->new;
  my $init = $gen->gen_init;

  like exception { $init->("My::Class", [], 'foo'); }, qr/not even.+$0/i;
  like exception { $init->("My::Class", "not_ref"); }, qr/ref.+$0/i;
  like exception { $init->("My::Class", {}, not_exists => 3) }, qr/not_exists.+$0/i;

  my $obj = [];
  is $init->("My::Class", $obj), $obj;
  isa_ok $obj, 'My::Class';
}

GEN_NEW: {
  my $gen = Evo::Class::Gen::XS->new;
  my $new = $gen->gen_new;

  like exception { $new->("My::Class", 'foo'); }, qr/not even.+$0/i;

  my $obj = $new->("My::Class");
  isa_ok $obj, 'My::Class';
  is reftype($obj), 'HASH';
}

GEN_MAP: {
  my $gen = Evo::Class::Gen::XS->new;
  my $new = $gen->gen_new;

  my $map = $gen->gen_attrs_map;
  is_deeply [$map->($new->('My::Class'))], [];
  $gen->gen_attr('foo', parse());

  $gen->gen_attr('bar', parse());
  my $obj = $new->('My::Class', foo => 'FOO');
  is_deeply [$map->($new->('My::Class', foo => 1))], [foo => 1, bar => undef];
  is_deeply [$map->($new->('My::Class', foo => 1, bar => 2))], [foo => 1, bar => 2];
}


#} for 1 .. 100_000;

done_testing;
