package Evo::Class::Common::GenPP;
use Evo '-Class::Common::Util; -Internal::Util; Carp croak';

sub new ($me, $package) {
  bless {_dv => {}, _dfn => {}, _check => {}, _required => [], _known => {}}, $me;
}

sub sync_attrs ($self, %attrs) {
  $self->{$_}->%* = () for qw(_known _check _dv _dfn);
  $self->{_required}->@* = ();
  for my $name (keys %attrs) {
    my %o = $attrs{$name}->%*;
    $self->{_known}{$name}++;
    push $self->{_required}->@*, $name if $o{required};
    (ref $o{default} ? $self->{_dfn} : $self->{_dv})->{$name} = $o{default} if exists $o{default};
    $self->{_check}{$name} = $o{check} if $o{check};
  }
}

sub gen_attr ($self, $name, %opts) {
  %opts = Evo::Class::Common::Util::process_is($name, %opts);
  my ($type, @args) = Evo::Class::Common::Util::compile_attr($name, %opts);
  $self->$type(@args);

}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Class::Common::GenPP

=head1 VERSION

version 0.0226

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
