# Evo - the next generation component-oriented development framework [![Build Status](https://travis-ci.org/alexbyk/perl-evo.svg?branch=master)](https://travis-ci.org/alexbyk/perl-evo)

# DESCRIPTION

This framework opens new age of perl programming
It provides rewritten and postmodern features like

- Rewritten sexy [Evo::Export](https://metacpan.org/pod/Evo::Export)
- Post modern component oriented programming [Evo::Comp](https://metacpan.org/pod/Evo::Comp) instead of OO
- (no docs yet) Fast Event-Loop [Evo::Loop](https://metacpan.org/pod/Evo::Loop) with unique feature zones (Not ready)
- Fast non recursive [Evo::Promises](https://metacpan.org/pod/Evo::Promises), 100% Promises/Spec A compatible. + Nice syntax with [Evo::Prm](https://metacpan.org/pod/Evo::Prm)
- (no docs yet) Interesting [Evo::Realm](https://metacpan.org/pod/Evo::Realm) design pattern, which is as handy as "Singleton" but without Singleton's flaws. Testable and mockable alternative of the global class
- Exception handling in pure perl: [Evo::Eval](https://metacpan.org/pod/Evo::Eval), "try catch" alternative. Like `Try::Tiny`, but without its bugs and much faster
- [Evo::Ee](https://metacpan.org/pod/Evo::Ee) - a component role that gives your component "EventEmitter" abilities

![GIF Demo](https://raw.github.com/alexbyk/perl-evo/master/demo.gif)

Vim ultisnips with `Evo` support can be found here: [vim-ultisnips-perl](https://github.com/alexbyk/vim-ultisnips-perl)

## AUTHOR

alexbyk.com

## COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
