package Evo::Comp::Util;
use Evo;
use Evo::Export '*';
use Carp 'croak';

sub croak_bad_value($value, $name, $msg=undef) : Export {
  my $err = qq'Bad value "$value" for attribute "$name"';
  $err .= ": $msg" if $msg;
  croak $err;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Comp::Util

=head1 VERSION

version 0.0185

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
