package Evo::Promises::Util;
use Evo '-Export *';
use List::Util 'first';
use Carp 'croak';

use constant {PENDING => 'PENDING', REJECTED => 'REJECTED', FULFILLED => 'FULFILLED'};

export qw(PENDING REJECTED FULFILLED);

sub is_locked_in : Export {
  croak unless defined wantarray;
  my ($parent, $child) = @_;
  first { $_ == $child } $parent->d_children->@*;
}

sub is_fulfilled_with : Export {
  croak unless defined wantarray;
  my ($v, $p) = @_;
  return unless $p->d_settled && $p->{state} eq FULFILLED;
  my $dv = $p->d_v;
  return defined $dv ? $v eq $dv : !defined $dv;
}

sub is_rejected_with : Export {
  croak unless defined wantarray;
  my ($v, $p) = @_;
  return unless $p->d_settled && $p->{state} eq REJECTED;
  my $dv = $p->d_v;
  return defined $dv ? $v eq $dv : !defined $dv;
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Promises::Util

=head1 VERSION

version 0.0174

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
