package Evo::Lib;
use Evo '-Export *', -Util, 'Carp croak';
use Time::HiRes qw(CLOCK_MONOTONIC clock_gettime);

PATCH: {
  no warnings 'once';
  *Evo::Lib::debug        = *Evo::Util::debug{CODE};
  *Evo::Lib::monkey_patch = *Evo::Util::monkey_patch{CODE};
}

export qw(debug context_result monkey_patch);

my $HAS_M_TIME = eval { clock_gettime(CLOCK_MONOTONIC); 1 };

export_anon steady_time => $HAS_M_TIME
  ? sub { clock_gettime(CLOCK_MONOTONIC); }
  : \&Time::HiRes::time;

sub context_result($) {
  return unless $_[0];
  return if !defined $_[0][0];
  $_[0][0] ? (@{$_[0][1]}) : $_[0][1];
}


sub ws_combine : Export {
  return unless @_;
  return $_[0] if @_ == 1;
  my @wrappers = reverse @_;
  sub {
    my $w = $_[0];
    $w = $_->($w) for @wrappers;
    $w;
  };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Lib

=head1 VERSION

version 0.0174

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
