package Evo::Loop::Role::Postpone;
use Evo '-Comp::Role *';

requires qw(zone_cb);

has data_postpone => default => sub { [] };

sub postpone_count : Role { $_[0]->data_postpone->@* }
sub postpone : Role { push $_[0]->data_postpone->@*, $_[0]->zone_cb($_[1]); }

sub postpone_process : Role {
  my $postpone = $_[0]->data_postpone;
  shift(@$postpone)->() while @$postpone;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Loop::Role::Postpone

=head1 VERSION

version 0.0173

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
