use Evo;
use Test::Evo::Benchmark;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test' unless $ENV{TEST_EVO_PERF};

my $EXPECT = 400_000 * $ENV{TEST_EVO_PERF};
my $N      = 5_00_000;

my $k = 0;
my $s = 0;
sub inc_s { $s += shift }
sub inc_k { $k += shift }


use Evo '-Try *';

#use Try::Tiny;
my $fn = sub {
  try { inc_s(1) } catch {1} finally { inc_k(1) };
};

faster_ok(fn => $fn, iters => $N, expect => $EXPECT, diag => 1);
is $k, $N;
is $s, $N;


done_testing;

