use Evo;
use Test::More;

BEGIN {
  local $@;
  plan 'skip_all', "perl 5.20.0 or greater is required for this test, you have $^V"
    unless eval { require 5.20.0 };
}

my $sub = sub {"$_[0] bad"};
my $EVAL = '$sub = sub ($val) { "$val ok" }';

NO_MODERN: {
  local $SIG{__WARN__} = sub { };
  local $@;
  eval $EVAL;
  is $sub->(11), '11 bad';
}

MODERN: {
  use Evo -Modern;
  local $@;
  eval $EVAL;
  is $sub->(22), '22 ok';
  diag $@ if $@;
}

MODERN: {
  use Evo::Modern;
  local $@;
  eval $EVAL;
  is $sub->(22), '22 ok';
  diag $@ if $@;
}

done_testing;
