package Evo::Export;
use Evo -Export::Exporter;
use Carp 'croak';
use Evo::Util;

my $EXPORTER;
sub EXPORTER() {$EXPORTER}

BEGIN {
  $EXPORTER = Evo::Export::Exporter::new();
}

# + export export_gen export_anon export_proxy export_requires export_hooks
my @EXPORT = qw(
  import export_install_in
  MODIFY_CODE_ATTRIBUTES EXPORTER);
EXPORTER->add_sub(__PACKAGE__, $_) for @EXPORT;

sub import { export_install_in(scalar caller, @_); }

sub export_install_in {
  my ($dst, $src, @list) = @_;
  EXPORTER->install($src, $dst, @list) if @list;
}

# pay attention: without provided name all aliases will be found by _find_subnames and exported
sub MODIFY_CODE_ATTRIBUTES {
  my ($pkg, $code, @attrs) = @_;
  my (@bad, @good);
  foreach my $attr (@attrs) {
    my ($attr_name, $val) = _parse_attr($attr);
    $attr_name eq 'Export' ? push @good, $val : push @bad, $attr;
  }
  return @bad if @bad;

  foreach my $name (@good) {
    my @names = $name ? ($name) : Evo::Util::find_subnames($pkg, $code);
    EXPORTER->add_gen($pkg, $_, sub {$code}) for @names;
  }

  return;
}

sub _parse_attr {
  my $attr = shift;
  $attr =~ /(\w+) ( \( \s* (\w+) \s* \) )?/x;
  return ($1, $3);
}


sub _add_gen { EXPORTER->add_gen(__PACKAGE__, shift, shift); }

_add_gen export_gen => sub {
  my $dst = shift;
  sub { EXPORTER->add_gen($dst, shift, shift) }
};

_add_gen export_anon => sub {
  my $dst = shift;
  sub {
    my ($name, $fn) = @_;
    EXPORTER->add_gen($dst, $name, sub {$fn});
  };
};

_add_gen export => sub {
  my $dst = shift;
  sub { EXPORTER->add_sub($dst, $_) for @_ }
};

_add_gen export_proxy => sub {
  my $dst = shift;
  sub { EXPORTER->proxy($dst, shift, shift); }
};

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Export

=head1 VERSION

version 0.0172

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
