package main;
use Evo;
use Test::More;
use Test::Fatal;

use Railway::Cleanup;
sub parents { Railway::Cleanup::_parents(@_) }

@Foo::ISA = ('Evo::Class::Base');
@Bar::ISA = ('Foo');
@Baz::ISA = ('Bar');
@Bad::ISA = ('P1', 'P2');

is_deeply [parents('Foo')], [qw( Evo::Class::Base)],         'right parents';
is_deeply [parents('Baz')], [qw( Bar Foo Evo::Class::Base)], 'right parents';
is_deeply [parents(Baz->new)], [qw( Bar Foo Evo::Class::Base)],
  'right parents by instance';

like exception { parents('Bad') }, qr/multiple.+P1; P2/;

done_testing;
