package main;
use Evo ':all';
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 700_000 * $ENV{TEST_EVO_PERF};
my $N      = 1000_000;

my ($t, $foo);

call {foo => 'MyFoo'}, sub {
  $t = timeit($N, cb(sub { $foo = dep('foo') }));
};

is $foo, 'MyFoo';

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
