package main;
use Evo;
use Test::More tests => 3;
use Evo::Spy;

my (@destroyed, @created, $fired);

{

  package MySpy;
  use Evo 'Evo::Spy';
  sub new { my $self = shift->SUPER::new(@_); push @created, "$self"; $self; }
  sub DESTROY { my $self = shift; push @destroyed, "$self"; }
}

FOO: {
  my $sub = sub { $fired++ };
  MySpy->new->origin($sub)->fn->();
  MySpy->new($sub)->();
}

is $fired, 2;
ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];


done_testing;


