use Evo;
use Test::More;
use Evo::Mdn;

my (@MSGS, @senders);
my $mdn = Evo::Mdn->new;
my $me  = My::Obj->new;

push @senders, My::Obj->new for 0 .. 3;
$mdn->subscribe($me, $_, 0, sub { push @MSGS, $_[2] }) for @senders;

$mdn->broadcast($senders[$_], $_) for 0 .. $#senders;
is_deeply \@MSGS, [0, 1, 2, 3];

# unchanged
$mdn->unsubscribe_from_all($me);
$mdn->broadcast($senders[$_], "bad$_") for 0 .. $#senders;
is_deeply \@MSGS, [0, 1, 2, 3];

{

  package My::Obj;
  use Evo -class;
}
done_testing;
