use Evo;
use Test::Fatal;
use Test::More;

use Evo::Guard;

my (@args, $fired);
my $cb = sub { @args = @_; $fired++ };

# 'must fire when out of scope'
($fired, @args) = ();
SCOPE: {
  my $guard = Evo::Guard->new($cb);
}
is $fired, 1;
ok !@args;

#'must fire when out of scope'
($fired, @args) = ();
like exception {
  my $guard = Evo::Guard->new($cb);
  die 'SuperError';
},
  qr/SuperError/;

is $fired, 1;
like shift @args, qr/SuperError/;


done_testing;
