use Evo;
use Test::More tests => 4;
use Test::Fatal;
use Evo::Guard;

my @WARNS;
local $SIG{__WARN__} = sub { push @WARNS, shift };

# die in cb, see what happens
TEST: {
  my @res;
  like exception {
    my $guard = Evo::Guard->new(sub { @res = @_; die "DIED" });
    die 'foo';
  }, qr/foo/;

  like shift @res, qr/foo/;
  like shift(@WARNS), qr/DIED/;
  ok !@WARNS;
}
