package Railway::Util;
use Evo;
use Exporter 'import';

our @EXPORT_OK = qw(run_wrappers curry_wrappers);
our %EXPORT_TAGS = (all => \@EXPORT_OK);

sub curry_wrappers {
  my ($bldr, @left);
  sub(@right) { run_wrappers($bldr, @left, @right) }
}

sub run_wrappers {
  my ($bldr, $cb) = (shift, pop);
  my @wrappers = reverse @_;
  foreach my $w (@wrappers) {
    $cb = $w->($bldr, $cb);
  }
  return $cb;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Railway::Util

=head1 VERSION

version 0.0171

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
