package main;
use Evo;
use Test::More;
use Benchmark ':all';
use Evo::Mdn;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 55_000 * $ENV{TEST_EVO_PERF};
my $N      = 100_000;
my $COUNTER;

my $sender = My::Obj->new;
my $mdn    = Evo::Mdn->new;

my $t = timeit(
  $N,
  sub {
    my $me = Foo->new;
    $mdn->subscribe($me, $sender);
    $mdn->broadcast($sender, 'foo');
    $mdn->unsubscribe($me, $sender);
  }
);

die unless $COUNTER == $N;
diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

{

  package My::Obj;
  use Evo -class;

  package Foo;
  use Evo -class;
  sub when_message { $COUNTER++ }
}
done_testing;
