use Evo;
use Benchmark ':all';
use Test::More;
use Evo::Flow;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};


my $EXPECT = 2 * $ENV{TEST_EVO_PERF};
my $N      = 10;
my $L      = 100_000;

my $flow = Evo::Flow->new;

sub asap {
  $flow->asap(@_);
}

# 50_000, 5


my $t = timeit(
  $N,

  sub {
    my $k;
    foreach my $n (1 .. $L) {
      asap(
        sub {
          asap(
            sub {
              asap(sub { $k = $n });
            }
          );

        }
      );
    }

    ok $k == $L, "$k = $L";
  }

);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";


done_testing;
