package main;
use Evo ':all';
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

# not more that 1.15 times
my $EXPECT_DIFF = 1.4;
my $EXPECT      = 320_000;
my $N           = 500_000;

{

  package MyFoo;
  use Evo -class;
  has val1 => '1';
  has 'val2';
  has 'val3';

  sub sum {
    my $self = shift;
    $self->val1 + $self->val2 + $self->val3;
  }
}


my ($t_evo, $t_pure);
call {foo => 'MyFoo'}, sub {
  $t_evo = timeit($N,
    sub { die unless dep('foo')->new(val2 => 2)->val3(3)->sum == 6 });
};

my $perf_evo = $N / $t_evo->cpu_a;
diag $perf_evo;
ok $perf_evo > $EXPECT, "$perf_evo > $EXPECT";

# compair with Class::->new
$t_pure
  = timeit($N, sub { die unless MyFoo::->new(val2 => 2)->val3(3)->sum == 6 });

my $perf_pure = $N / $t_pure->cpu_a;
my $diff      = $perf_pure / $perf_evo;
diag $perf_pure;
diag $diff;

ok $diff < $EXPECT_DIFF, "$diff < $EXPECT_DIFF";

done_testing;
