package main;
use Evo;
use Test::More tests => 4;
use Evo::Mdn;

my (@destroyed, @created, $res, @MSGS);

{

  package My::Obj;
  use Evo -class;
}

# mdn is going to die, so delete all stores no matter if
# store object is still alive
my $from = My::Obj->new;
FOO: {
  my $mdn = MyMDN->new;
  my $to  = MyFoo->new;
  my $to2 = MyFoo->new;
  my @msgs;

  # in cyrcle in clousure
  $mdn->subscribe($to2, $from, 1,
    sub { $from and $to2 and push @msgs, $_[2] });
  $mdn->subscribe($to, $from, 1);
  $mdn->broadcast($from, 'hello');
  $mdn->broadcast($from, $to);
  $mdn->broadcast($from, $from);
  is_deeply \@MSGS, ['hello', $to, $from];
  is_deeply \@msgs, ['hello', $to, $from];
  @MSGS = ();
  @msgs = ();

}

ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];

{

  package MyMDN;
  use Evo 'Evo::Mdn';
  sub new { my $self = shift->SUPER::new(@_); push @created, "$self"; $self; }

  sub DESTROY {
    my $self = shift;
    push @destroyed, "$self";
    $self->SUPER::DESTROY;
  }


  package MyFoo;
  use Evo -class;
  sub when_message { shift; push @MSGS, shift }

  sub new { my $self = shift->SUPER::new(@_); push @created, "$self"; $self; }
  sub DESTROY { my $self = shift; push @destroyed, "$self"; }
}

done_testing;


