package main;
use Evo;
use Test::More;
use Evo::Mdn;

my (@destroyed, @created, $res);

{

  package My::Obj;
  use Evo -class;
}

my $mdn = Evo::Mdn->new;

FOO: {
  my $from = My::Obj->new;
  my @msgs;

  # we create a receiver circular in clousure.
  my $to  = MyFoo->new;
  my $to2 = MyFoo->new;
  $mdn->subscribe($to,  $from, 0, sub { $to  and push @msgs, $_[2] });
  $mdn->subscribe($to2, $from, 1, sub { $to2 and push @msgs, $_[2] });
  $mdn->broadcast($from, 'hello');

  is_deeply \@msgs, ['hello', 'hello'];
  @msgs = ();
}

ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];

{

  package MyFoo;
  use Evo -class;

  sub new { my $self = shift->SUPER::new(@_); push @created, "$self"; $self; }
  sub DESTROY { my $self = shift; push @destroyed, "$self"; }
}

done_testing;


