use Evo;
use Test::More tests => 3;
use Evo::Flow;

my $flow = Evo::Flow->new;

my @passed;
$flow->asap(
  sub {
    push @passed, 1;
    $flow->asap(sub { push @passed, 3 }, sub { push @passed, 4 });
  },
  sub { push @passed, 2 }
);

$flow->asap(
  sub {

    # new, so blocking
    Evo::Flow->new->asap(sub { push @passed, 5 });
    push @passed, 6;
  }
);
is_deeply \@passed, [1, 2, 3, 4, 5, 6], 'right order';


my $res;
$flow->asap(
  sub {
    $flow->asap(
      sub {
        $flow->asap(sub { $res = 'ok' });
      }
    );
  }
);
ok $res;

my @states = ();
my $stash = {state => 'nb'};
$flow->asap(
  sub {
    push @states, $stash->{state};
    local $stash->{state} = 'blocking?';
    $flow->asap(sub { push @states, $stash->{state}; });
  }
);
is_deeply \@states, ['nb', 'nb'];

done_testing;
