use Evo;
use Test::More tests => 7;
use Evo::Dsl;

my $dsl = Evo::Dsl->new;

is $dsl->depth, 0, 'right depth on instance';

$dsl->call(
  sub {
    is $dsl->depth, 1;
    $dsl->call({}, sub { is $dsl->depth, 2; });
    is $dsl->depth, 1;
  }
);


# die has to correctly decrease a counter too
$dsl->call(
  sub {
    is $dsl->depth, 1;
    eval {
      $dsl->call(sub {die});
    };
    is $dsl->depth, 1;
    is $dsl->depth, 1;
  }
);

done_testing;
