package Evo::Stash::Once;
use Evo 'Evo::Stash';

sub set {
  my ($self, $key, $me, $weaken) = @_;
  Carp::croak "object $key already has a stash" if $self->get($key);
  $self->SUPER::set($key, $me, $weaken);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Stash::Once

=head1 VERSION

version 0.0170

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
