use Evo::Base -strict;
use Evo::Spy;
use Test::Spec;
use Evo::Base -strict;

describe 'spy', sub {
  my ($i, $spy, $want);
  my @return;
  before each => sub {
    $want   = 33;
    @return = ();
    $i      = 0;
    $spy    = Evo::Spy->new(
      sub {
        $i++;
        $want = wantarray;
        return if !defined $want;
        return $want ? (1, 2) : '1-2';
      }
    );
  };

  it 'must execude code by code want scalar', sub {
    push @return, scalar $spy->code->();
    ok defined $want && !$want;
    is $return[0], '1-2';
  };
  it 'must execude code by code want array', sub {
    @return = $spy->code->();
    is_deeply \@return, [1, 2];
    ok $want;
  };
  it 'must execude code by code want nothing', sub {
    $spy->code->();
    ok !defined $want;
  };
  it 'must execude code by code want scalar', sub {
    push @return, scalar $spy->();
    ok defined $want && !$want;
    is $return[0], '1-2';
  };
  it 'must execude code by code want array', sub {
    @return = $spy->();
    is_deeply \@return, [1, 2];
    ok $want;
  };
  it 'must execude code by code want nothing', sub {
    $spy->();
    ok !defined $want;
  };

  after each => sub {
    is $spy->calls->@*, 1;
    is $i, 1;
    is $spy->calls->[0]->{wantarray},     $want;
    is_deeply $spy->calls->[0]->{return}, \@return;
  };
};

runtests unless caller;
