use Evo::Base -strict;
use Evo::Spy;
use Test::Spec;
use Test::Fatal;
use Evo::Base -strict;

describe 'spy exception', sub {
  it 'must be stored' => sub {
    my $i;
    my $spy = Evo::Spy->new(sub { $i++; die "FOO" });
    like exception { $spy->() }, qr/FOO/;
    like $spy->calls->[0]->{exception}, qr/FOO/;
    is $i, 1;
  };

  it 'must be undefined if all is ok' => sub {
    my $i;
    my $spy = Evo::Spy->new(sub { $i++ });
    $spy->();
    ok !$spy->calls->[0]->{exception};
    is $i, 1;
  };


};

runtests unless caller;
