use Evo::Base -strict;
use Test::More tests => 3;
use Evo::Manager;

my $mngr = Evo::Manager->singleton;

$mngr->dsl_call(
  {foo => 'bar', a => 2},
  1, 2,
  sub {
    is_deeply \@_, [1, 2], 'right args';

    $mngr->dsl_call({foo => 'baz'},
      sub { is_deeply $mngr->dsl_stash, {foo => 'baz'}, 'overriden' });
  }
);

# empty dsl_stash
$mngr->dsl_call(sub { ok $mngr->dsl_stash });

done_testing;

1;
