package Evo::MDN::Util;
use Evo::Base -strict;
use Hash::Util::FieldHash qw(id id_2obj);
use Exporter 'import';

our @EXPORT_OK = qw(list_subscribers list_stores is_subscribed is_stored);
our %EXPORT_TAGS = (all => \@EXPORT_OK);

sub list_stores : prototype($) {
  my $sender = shift;
  return unless my $hash = Evo::MDN->_all_stores->{$sender};
  map { id_2obj($_) } keys $hash->%*;
}

sub list_subscribers : prototype($) {
  my $sender = shift;
  return unless my $hash = Evo::MDN->_all_senders->{$sender};
  map { id_2obj($_) } keys $hash->%*;
}

sub is_subscribed($me, $to) {
  Evo::MDN->_all_senders->{$to} && Evo::MDN->_all_senders->{$to}->{id $me};
}

sub is_stored($me, $to) {
  Evo::MDN->_all_stores->{$to} && Evo::MDN->_all_stores->{$to}->{id $me};
}

1;

# ABSTRACT: MDN Util

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::MDN::Util - MDN Util

=head1 VERSION

version 0.0157

=head1 METHODS

=head2 is_stored

Check if object is stored by another

=head2 is_subscribed

Check if an object is subscribed by another

=head2 list_stores

returns a list of object stored by this one

=head2 list_subscribers

returns a list of object subscribed to this one

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
