package main;
use Evo::Base -strict;
use Test::More;
use Evo::MDN;
use Test::Fatal;
use Hash::Util::FieldHash qw(register id id_2obj);

my ($FROM, $MSG, $DESTROYED);
my $mdn  = Evo::MDN->new;
my $from = Evo::Base->new;

my ($id, $me);

# firstly check if implementation didn't change

$me = Receiver->new;
$id = id $me;
$mdn->subscribe($me, $from);
ok $mdn->_all_senders->{id($from)}->{$id};
ok $mdn->_all_subscribers->{$id};

$mdn->unsubscribe($me, $from);
ok !$mdn->_all_senders->{id($from)}->{$id};
ok !$mdn->_all_subscribers->{$id};

# should automatically be destroyed
$mdn->subscribe($me, $from);
undef $me;
ok !$mdn->_all_subscribers->{$id};

# and cleared after the first broadcast
$mdn->broadcast($from, 'foo');
ok !$mdn->_all_senders->{id($from)}->{$id};


{

  package Receiver;
  use Evo::Base -base;
  sub when_message { }
}

done_testing;
