package Evo::MDN;
use Evo::Base -base;
use Hash::Util::FieldHash qw(register id id_2obj);

Hash::Util::FieldHash::fieldhashes \my (%SUBSCRIBERS, %SENDERS);

# so if subscriber was destroyed, but not called unsubscribe,
# that situation will be detected and subscriber will be cleared from
# all senders
sub broadcast ($self, $sender, $msg) {
  foreach my $id (keys _senders($sender)->%*) {

    # was destroyed but not unsubscribed
    $SUBSCRIBERS{$id}
      ? id_2obj($id)->when_message($msg, $sender)
      : _unsubscribe_id($id, $sender);
  }
}

sub subscribe ($self, $me, $to) {
  Carp::croak "implement when_message in $me" unless $me->can('when_message');
  $SUBSCRIBERS{$me}++;
  _subscribe_id(id($me), $to);
}

sub _subscribe_id ($me_id, $to) { _senders($to)->{$me_id}++; }

sub unsubscribe ($self, $me, $from) { _unsubscribe_id(id($me), $from) }

sub _unsubscribe_id ($me_id, $from) {
  delete _senders($from)->{$me_id};
  delete _all_subscribers()->{$me_id};
}

# don't try to register subscriptions to avoid,
# all keys. hashes works fast enought and in most
# keyses shoud work much faster because you don't need
# to register a second instance

sub unsubscribe_from_all ($self, $me) { _unsubscribe_from_all_id(id($me)); }

sub _unsubscribe_from_all_id ($me_id) {
  _unsubscribe_id($me_id, $_) for keys _all_senders()->%*;
}

sub _all_subscribers  { return \%SUBSCRIBERS; }
sub _all_senders      { return \%SENDERS; }
sub _senders($sender) { $SENDERS{$sender} //= {}; }

1;

# ABSTRACT: A messanger

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::MDN - A messanger

=head1 VERSION

version 0.0153

=head1 SYNOPSIS

  my $mdn    = Evo::MDN->singleton;
  my $sender = Evo::Base->new;
  my $me     = Evo::Base->new;

  $mdn->subscribe($me, $sender);
  $mdn->broadcast($sender, 'foo');

=head1 DESCRIPTION

  Messenger

=head1 METHODS

=head2 broadcast

  Sends a message to all subscribers. when_message will be invoked with
  the sender and message for the subscribers

=head2 subscribe

  Subscribe one object to another

=head2 unsubscribe

  Unsubscribe one object from another

=head2 unsubscribe_from_all

  Unsubscribe me from all senders

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
