package main;
use Evo::Base -strict;
use Test::More tests => 1;
use Evo ':msn';

my $from = Foo->new;
my $to   = Foo->new;
my @messages;

msn_subscribe $to,   $from;
msn_broadcast $from, 'hello';
msn_broadcast $from, 'world';
msn_unsubscribe $to, $from;
msn_broadcast $from, 'bad';

is_deeply \@messages, [qw(hello world)];

{

  package Foo;
  use Evo::Base -base;
  sub when_message { push @messages, $_[1] }
}


