use Evo::Base -strict;
use Evo::Manager;
use Test::More tests => 16;

my $mngr  = Evo::Manager->new;
my $mngr2 = Evo::Manager->new;

is $mngr->dsl_depth, 0, 'right depth on instance';


$mngr->dsl_call(
  sub {
    is $mngr->dsl_depth,  1;
    is $mngr2->dsl_depth, 0;


    $mngr->dsl_call({}, sub { is $mngr->dsl_depth, 2; });
    $mngr->dsl_extend({}, sub { is $mngr->dsl_depth, 2; });

    $mngr2->dsl_call(
      sub {
        is $mngr2->dsl_depth, 1;
        is $mngr->dsl_depth,  1;
      }
    );

    is $mngr->dsl_depth,  1;
    is $mngr2->dsl_depth, 0;

    $mngr2->dsl_extend(
      {},
      sub {
        is $mngr2->dsl_depth, 1;
        is $mngr->dsl_depth,  1;
      }
    );

    is $mngr->dsl_depth,  1;
    is $mngr2->dsl_depth, 0;

  }
);


# die has to correctly decrease a counter too
$mngr->dsl_call(
  sub {

    is $mngr->dsl_depth, 1;

    eval {
      $mngr->dsl_call(sub {die});
    };

    is $mngr->dsl_depth, 1;

    eval {
      $mngr->dsl_extend({}, sub {die});
    };

    is $mngr->dsl_depth, 1;
  }
);

done_testing;
