package Evo::Messenger;
use Evo::Base -base;
use Hash::Util::FieldHash qw(register id id_2obj);

Hash::Util::FieldHash::fieldhash(my %SUBSCRIBERS);

sub broadcast ($self, $sender, $msg) {
  foreach my $id (keys $self->_subscribers($sender)->%*) {
    id_2obj($id)->when_message($sender, $msg);
  }
}
sub _subscribers { $SUBSCRIBERS{$_[1]} //= {}; }

sub subscribe ($self, $subscriber, $sender) {
  register($subscriber);
  $self->_subscribers($sender)->{id($subscriber)}++;
}

sub unsubscribe ($self, $subscriber, $sender) {
  delete $self->_subscribers($sender)->{id($subscriber)};
}

sub _all { return \%SUBSCRIBERS; }

sub singleton($class,@args) { state $s = (ref $class || $class)->new(@args); }

1;

# ABSTRACT: A messanger

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Messenger - A messanger

=head1 VERSION

version 0.014

=head1 SYNOPSIS

  my $msn      = Evo::Messenger->singleton;
  my $sender   = Evo::Base->new;
  my $receiver = Evo::Base->new;

  $msn->subscribe($receiver, $sender);
  $msn->broadcast($sender, 'foo');

=head1 DESCRIPTION

  Messenger

=head1 METHODS

=head2 broadcast

  Sends a message to all subscribers. when_message will be invoked with
  the sender and message for the subscribers

=head2 subscribe

  Subscribe one object to another

=head2 unsubscribe

  Unsubscribe one object from another

=head2 singleton

  Returns a singleton

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
