package SmotifTF::ClusterShellScripts;

use 5.8.8;
use strict;
use warnings;

use Config::Simple;
use Text::Template;
use Carp;

=head1 NAME

    ClusterShellScripts 

    Routines to submit a job to gridengine system.

=cut


=for
[run_in_cluster]
shell_script_templates=/home/brinda/test_brinda
queue_name=queuename
username=username
email=email
=cut


# accessing a block of an ini-file;
my $config_file = $ENV{'SMOTIFTF_CONFIG_FILE'};

croak "Environmental variable SMOTIFTF_CONFIG_FILE should be set" unless $config_file;

my $cfg = new Config::Simple($config_file);
my $cluster = $cfg->param( -block => 'run_in_cluster' );

my $shell_path = $cluster->{'shell_script_templates_path'};
my $queue_name = $cluster->{'queue_name'};
my $username   = $cluster->{'username'};
my $email      = $cluster->{'email'};

die "shell_script_templates_path is required" unless $shell_path;
die "queue_name is required" unless $queue_name;
die "username is required"   unless $username;
die "email is required"      unless $email;



=head1 SYNOPSIS
    
Routines to submit a job to gridengine system.

=cut


#=for

##!/bin/sh
# This is a simple example of a SGE batch script

# request Bourne shell as shell for job
#$ -S /bin/sh

#
# print date and time
#date
# Sleep for 20 seconds
#sleep 20
# print date and time again
#date

=head2  simple_sge_batch 
 
routine to generate a simple example of SGE batch script

=cut

sub do_simple_sge_batch {
    use Text::Template;
    
    my ($seconds, $out_file) = @_;
    # my $seconds = 20 unless $seconds;
    $seconds ||= 20;
    
    my $template_file = "$shell_path/filename.tmpl";

    my $template = Text::Template->new( TYPE => 'FILE',  
        SOURCE => $template_file
    )
	or die "Couldn't construct template: $Text::Template::ERROR";
   
    my %hash = ( seconds => $seconds );
   
    my $result = $template->fill_in(HASH => \%hash, OUTPUT => $out_file);
    
    if (defined $result) { 
	    return 1; 
    }
    else { 
	    die "Couldn't fill in template: $Text::Template::ERROR"; 
    }  
}

=head1 AUTHOR

Brinda Vallat, Vilas Menon , C<< <brinda at fiserlab.org andras@fiserlab.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-. at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=.>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.




=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc ClusterShellScripts


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=.>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/.>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/.>

=item * Search CPAN

L<http://search.cpan.org/dist/./>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2015 Brinda Vallat, Vilas Menon .

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut

1; # End of ClusterShellScripts
