=begin comment

QueryBuilderApi

Active Query Builder Web API lets create, analyze and modify SQL queries for different database servers using RESTful HTTP requests to a cloud-based service. It requires SQL execution context (information about database schema and used database server) to be stored under the registered account at https://webapi.activequerybuilder.com/.

OpenAPI spec version: 1.1.5
Contact: support@activedbsoft.com
Generated by: https://github.com/swagger-api/swagger-codegen.git

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package SQL::QueryBuilder::WebApi::ActiveQueryBuilderApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use SQL::QueryBuilder::WebApi::ApiClient;
use SQL::QueryBuilder::WebApi::Configuration;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class   = shift;
    my (%self) = (
        'api_client' => SQL::QueryBuilder::WebApi::ApiClient->instance,
        @_
    );

    #my $self = {
    #    #api_client => $options->{api_client}
    #    api_client => $default_api_client
    #}; 

    bless \%self, $class;

}


#
# get_query_columns_post
#
# 
# 
# @param SqlQuery $query Information about SQL query and it&#39;s context. (required)
{
    my $params = {
    'query' => {
        data_type => 'SqlQuery',
        description => 'Information about SQL query and it&#39;s context.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_query_columns_post' } = { 
    	summary => '',
        params => $params,
        returns => 'ARRAY[QueryColumn]',
        };
}
# @return ARRAY[QueryColumn]
#
sub get_query_columns_post {
    my ($self, %args) = @_;

    # verify the required parameter 'query' is set
    unless (exists $args{'query'}) {
      croak("Missing the required parameter 'query' when calling get_query_columns_post");
    }

    # parse inputs
    my $_resource_path = '/getQueryColumns';
    $_resource_path =~ s/{format}/json/; # default format to json

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json', 'text/html');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json', 'text/xml');

    my $_body_data;
    # body params
    if ( exists $args{'query'}) {
        $_body_data = $args{'query'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[QueryColumn]', $response);
    return $_response_object;
}

#
# transform_sql_post
#
# 
# 
# @param Transform $transform SQL transformation parameters and commands. (required)
{
    my $params = {
    'transform' => {
        data_type => 'Transform',
        description => 'SQL transformation parameters and commands.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'transform_sql_post' } = { 
    	summary => '',
        params => $params,
        returns => 'TransformResult',
        };
}
# @return TransformResult
#
sub transform_sql_post {
    my ($self, %args) = @_;

    # verify the required parameter 'transform' is set
    unless (exists $args{'transform'}) {
      croak("Missing the required parameter 'transform' when calling transform_sql_post");
    }

    # parse inputs
    my $_resource_path = '/transformSQL';
    $_resource_path =~ s/{format}/json/; # default format to json

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json', 'text/html');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json', 'text/xml');

    my $_body_data;
    # body params
    if ( exists $args{'transform'}) {
        $_body_data = $args{'transform'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TransformResult', $response);
    return $_response_object;
}

1;
