#!/usr/bin/perl -w
#########################################################################
#
# Serz Minus, <minus@mail333.com>
#
# Copyright (C) 1998-2014 D&D Corporation. All Rights Reserved
# 
# This is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.
#
# $Id$
#
#########################################################################
use Test::More tests => 1;
#ok(1,"Temporary ok")
#__END__

use CTK::Util;
use ExtUtils::Manifest qw/ maniread /;
use File::Find;
#use File::Spec;

use constant {
        EXCLUDE => [
                qr/^cache/,
                qr/^log/,
                qr/^blib/,
                qr/^db/,
                qr/^(my)?meta/i,
                qr/^makefile/i,
                qr/^pm_to_blib/,
                #qr/^src\/.+?\.(gz|zip)$/,
                qr/^xs/,
            ],
    };

#my $updir = File::Spec->updir();
my $updir = curdir();
my $manifest = maniread(catfile($updir,"MANIFEST"));

my %found = ();
find({ wanted => sub {
    return if -d $_;
    my $name = substr $_, length($updir)+1;
    return if $name =~ /^\.((svn)|(csv)|(git))/i;
    
    if (defined $manifest->{$name}) {
	$manifest->{$name} = "OK";
    } else {
        $manifest->{$name} = "MISMATCH";
    }
    
}, no_chdir => 1 }, $updir);

foreach my $k (keys %$manifest) {
    next if grep { $k =~ $_ } @{(EXCLUDE)};
    my $v = $manifest->{$k} || 'NOT FOUND';
    $found{$k} = $v unless $v eq "OK"
}

my @err = ();
if (%found) {
   while (my ($k,$v) = each(%found)) {
       my $e = sprintf "FILE %9s : \"%s\"",$v,$k;
       warn $e;
       push @err, $e;
   }
}
ok(!%found, "MANIFEST:\n".join "\n",@err); 

1;
