package Foo;

=head1 NAME

Foo - Input point your project

=head1 VERSION

Version 1.00

=head1 SYNOPSIS

    use Foo;

=head1 DESCRIPTION

Input point your project

=head1 HISTORY

=over 8

=item B<1.00 / Thu Jul 24 10:21:49 2014 GMT>

Init version

=back

See C<CHANGES> file

=head1 SEE ALSO

L<WWW::MLite>

=head1 AUTHOR

Mr. Anonymous E<lt>email@mexample.comE<gt>

=head1 COPYRIGHT

Copyright (C) 1998-2014 D&D Corporation. All Rights Reserved

=head1 LICENSE

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

See C<LICENSE> file

=cut

use vars qw($VERSION);
$VERSION = 1.00;

## MODEL
use DBI;
#use WWW::MLite::Store::DBI;

## VIEW
use CGI;
use CGI::Session;
use TemplateM;

## CONTROLLER
use WWW::MLite::Util;
use CTK::Util qw/ :BASE :FORMAT /;
use CTK::ConfGenUtil;
use CTK::TFVals qw/ :ALL /;
#use XML::Simple;    #  AJAX 
#use JSON;           #  AJAX 

sub handler {
    my $self = shift;
    
    #    -      
    #$self->register(qw/Handlers::Foo/);
    
    #$self->config->set(debug => 1);
    #$self->config->set(loglevel => 0);
    #$self->config->set(syslog => 1);
    #$self->config->set(logfile => 'qqq.log');

    #       ,    
    my $q = new CGI;
    $self->set( 'q' => $q );
    
    #     
    my ($actObject,$actEvent) = split /[,]/, $q->param("action") || '';
    $actObject = 'default' unless $actObject && $self->ActionCheck($actObject);
    $actEvent  = $actEvent && $actEvent =~ /go/ ? 'go' : '';
    $self->set( 'actObject' => $actObject );
    $self->set( 'actEvent' => $actEvent );
    
    #   
    my $mdata = $self->getActionRecord($actObject);
    
    #    
    #if (value($mdata => "mysql_mybase_enable")) {
    #    #$WWW::MLite::Store::DBI::DEBUG_FORCE = 1;
    #    my $mysql_cfg = $self->config->mysql;
    #    $self->set( 'mysql_mybase' => new WWW::MLite::Store::DBI (
    #        -driver   => 'mysql',
    #        -host     => value($mysql_cfg => "MyBase/host"),
    #        -name     => value($mysql_cfg => "MyBase/name"),
    #        -user     => value($mysql_cfg => "MyBase/user"),
    #        -password => value($mysql_cfg => "MyBase/password"),
    #        -attr       => {
    #            RaiseError => 0,
    #            PrintError => 0,
    #            mysql_enable_utf8 => 1,
    #        },
    #    ));
    #}
    
    #if (value($mdata => "oracle_prod_enable")) {
    #    my $oracle_cfg = $self->config->oracle;
    #    $self->set( 'oracle_prod' => new WWW::MLite::Store::DBI (
    #        -driver   => 'Oracle',
    #        -name     => value($oracle_cfg => "PROD/sid"),
    #        -user     => value($oracle_cfg => "PROD/user"),
    #        -password => value($oracle_cfg => "PROD/password"),
    #        -attr       => {
    #            RaiseError => 0,
    #            PrintError => 0,
    #        },
    #    ));
    #}
    
    #  - ($template)   : %usr, %h, @error
    my (%usr, %h, $template, @error);
    %usr = (); foreach ($q->all_parameters) { $usr{$_} = $q->param($_) }
    
    #   UTF8    %usr     !!
    #     utf8exclude     !!!
    if (value($mdata => "utf8exclude")) {
        my $tke = value($mdata => "utf8exclude");
        foreach my $k ($q->all_parameters) {
            Encode::_utf8_on($usr{$k}) unless grep {$_ eq $k} @$tke;
        }
    }
    $self->set( 'h' => \%h );
    $self->set( 'usr' => \%usr );
    $self->set( 'error' => \@error );
    $self->set( 'status' => 0 );
    

    $template = new TemplateM(
        -file  => value($mdata => "tplfile")
            || (
                (value($mdata => "tplprefix") || $self->config->tplprefix || 'shtml').
                "/$actObject".
                (value($mdata => "tplsuffix") || $self->config->tplsuffix || '.shtml')
            ),
        -cache => $self->config->tplcachedir || undef,
        -time  => value($mdata => "tpltime") || $self->config->tpltime || 0,
        -utf8  => 1,
    );
    $self->set( 'template' => uv2null($template) );
    
    #  
    my $session_key = $self->config->sessionkey || 'SID';
    my $dbdir = $self->config->dbdir || catdir($self->config->document_root, 'db');
    CGI::Session->name($session_key);
    my $session;
    if (value($mdata => "session_enable")) {
        my $dbhsqlite = DBI->connect(sprintf("dbi:SQLite:dbname=%s", catfile($dbdir,($self->prefix()).'_sessions.db')),"","", { RaiseError => 1, sqlite_unicode => 1, });
        $dbhsqlite->do('CREATE TABLE IF NOT EXISTS sessions ( id CHAR(32) NOT NULL PRIMARY KEY, a_session TEXT NOT NULL )');
        $session = new CGI::Session("driver:sqlite", undef, { Handle=>$dbhsqlite });
        $self->set( 'session' => $session );
    }
    
    #  
    my $status = $self->ActionTransaction($actObject,$actEvent);
    #return $status if $status > 1;

    #  
    $session->flush() if value($mdata => "session_enable");

    1;
}

sub access { #    
    my $self = shift;
    1;
}
sub deny {
    my $self = shift;
    my $q           = $self->q;
    my $error       = $self->error;
    binmode STDOUT, ":raw:utf8"; #binmode(STDOUT,':utf8');
    print $q->redirect(
            -uri=>"/shtml/error/error.shtml?".$q->escape(join("\n",@$error)),
            -status => 302,
        );
    return 0;
}
sub before_view { #   
    my $self = shift;
    my $q           = $self->q;
    my $actObject   = $self->actObject();
    my $actEvent    = $self->actEvent();
    my $mdata = $self->getActionRecord($actObject);
    binmode STDOUT, ":raw:utf8"; #binmode(STDOUT,':utf8');
    print $q->header( -type => (value($mdata => "contenttype") || $self->config->contenttype) );
    1;
}
sub after_view { #   
    my $self = shift;
    my $q           = $self->q;
    my $template    = $self->template;
    my $usr         = $self->usr;
    my $h           = $self->h;
    my $error       = $self->error;
    
    #     
    $h->{info} = $usr->{info} if defined $usr->{info};
    $template->cast_if("info", defined $h->{info}); 

    #     
    $template->cast_if("error", @$error);
    my $errbox = $template->start("error");
    $errbox->loop(error=>$_) foreach (@$error);
    $errbox->finish();

    #   
    $h->{DEBUG_TIME} = sprintf "%.3f sec\n", (getHiTime() - $self->config->hitime);
    
    #     
    my $session_key = $self->config->sessionkey || 'SID';
    $template->cast_if('authorized', $q->cookie($session_key) ? 1 : 0);
    #$::template->cast_if('is_user', handler::login::is_user());
    #$::template->cast_if('is_admin', handler::login::is_admin());

    #   
    $template->stash($h);
    print $template->output();
    1;
}

1;
