package NKTI::general::char::split;

use strict;
use warnings;

# Define Version
# ----------------------------------------------------------------
our $VERSION = '0.05';

# Create Action Split Character in string :
# ------------------------------------------------------------------------
=head1 MODULE base_length()

    Parameter Modul :
    ----------------------------------------
    _string =>    Parameter yang berisi string yang akan di split.
    _length =>    Parameter yang berisi jumlah.

=cut
sub based_length {

    # Declare parameter module :
    # ----------------------------------------------------------------
    my ($self, $string, $length) = @_;

    # Action Convert string to array based length of char :
    # ----------------------------------------------------------------
    my $this_length = 'A'.$length;
    my @data = unpack("($this_length)*", $string);

    # Return Result :
    # ----------------------------------------------------------------
    return @data;
}
# End of Create Action Split Character in string.
# ===========================================================================================================

# Create Module Split Charcter by Character :
# ------------------------------------------------------------------------
=head1 MODULE based_char()

    Parameter Modul :
    ----------------------------------------
    _string =>      Parameter yang berisi string untuk yang akna displit.
    _delimiter =>   Parameter yang berisi karakter pemisa untuk proses split karakter.
    _join =>        Parameter yang berisi nilai aksi join.
                    IF == 1 --> Split direct join,
                    IF == 0 --> Split return array.
=cut
sub based_char {

    # Declara parameter module :
    # ----------------------------------------------------------------
    my ($self, $string, $delimiter, $join) = @_;

    # Declare variable for action split :
    # ----------------------------------------------------------------
    my @split = split /$delimiter/, $string;

    # Check IF $join eq 1 :
    # ----------------------------------------------------------------
    if ($join eq 1) {

        # Declare scalar for Placing result :
        # ----------------------------------------------------------------
        my $str_data = '';

        # Prepare To While loop for Join result split :
        # ----------------------------------------------------------------
        my $i = 0;
        my $keys_split = keys (@split);
        my $until_loop = $keys_split;

        # While Loop for Join result split :
        # ----------------------------------------------------------------------------------------
        while ($i < $until_loop) {

            # Join Result split :
            # ----------------------------------------------------------------
            $str_data .= $split[$i];
            
            # Auto Increment :
            # ----------------------------------------------------------------
            $i++;
        }
        # End of While loop for Join result split.
        # ========================================================================================

        # Return Result :
        # ----------------------------------------------------------------
        return $str_data;
    }
    # End of check IF $join eq 1.
    # ----------------------------------------------------------------

    # Check IF $join eq 1 :
    # ----------------------------------------------------------------
    else {

        # Return Result :
        # ----------------------------------------------------------------
        return @split;
    }
    # End of check IF $join eq 1.
    # ----------------------------------------------------------------
}
# End of Create Module Split Charcter by Character.
# ===========================================================================================================

1;

__END__
=head1 AUTHOR
    Achmad Yusri Afandi, (linuxer08@gmail.com)

=head1 COPYRIGHT AND LICENSE
    Copyright (c) 2016, Achmad Yusri Afandi, All Rights reserved.

    Pustaka yang berfungsi untuk melakukan Split Karakter.

=cut