package NKTI::general::dbconnect;

use strict;
use warnings;
use JSON;
use DBI;

# Define Version :
# ----------------------------------------------------------------
our $VERSION = '0.04';

# Create Module for Connection MySQL Database :
# ------------------------------------------------------------------------
# Module for MySQL Database Connection.
#
=head1 MODULE mysql()

		Description Subroutine :
		----------------------------------------
		Subroutine untuk koneksi MySQL Database.

    Parameter Modul :
    ----------------------------------------
    _db_config =>       Parameter yang berisi hash config database.

=cut
sub mysql {

    # Define parameter Module :
    # ----------------------------------------------------------------
    my $class = shift;
    my $self = {
        _db_config => shift
    };
    bless $self, $class;

    # Define scalar for parameter module :
    # ----------------------------------------------------------------
    my $get_db_config = $self->{_db_config};

    # Declare scalar for result :
    # ----------------------------------------------------------------
    my $dbh;

    # Declare scalar for Database Config :
    # ----------------------------------------------------------------
    my $db_config = decode_json($get_db_config);
    my $db_user = $db_config->{'db_user'};
    my $db_pass = $db_config->{'db_pass'};
    my $db_name = $db_config->{'db_name'};
    my $db_host = $db_config->{'db_host'};

    # Define database conection :
    # ----------------------------------------------------------------
    my $dsn = 'DBI:mysql:database='.$db_name.';host='.$db_host;
    $dbh = DBI->connect($dsn, $db_user, $db_pass, {RaiseError => 1});

    # Return Result :
    # ----------------------------------------------------------------
    return $dbh;
}
# End of Create Module for Connection MySQL Database.
# ===========================================================================================================

# Module for Connection PostgreSQL Database :
# ------------------------------------------------------------------------
=head1 MODULE pgsql()
	
	Deskripsi subroutne pgsql() :
	----------------------------------------

	Parameter subroutne pgsql() :
	----------------------------------------
	describ_param

=cut
sub pgsql {
	# ----------------------------------------------------------------
	# Defien parameter Subroutine :
	# ----------------------------------------------------------------
    my $class = shift;
    my $self = {
        _db_config => shift
    };
    bless $self, $class;
    # ----------------------------------------------------------------
    # Define scalar for parameter module :
    # ----------------------------------------------------------------
    my $get_db_config = $self->{_db_config};
    # ----------------------------------------------------------------
    # Declare scalar for result :
    # ----------------------------------------------------------------
    my $dbh;
    # ----------------------------------------------------------------
    # Declare scalar for Database Config :
    # ----------------------------------------------------------------
    my $db_config = decode_json($get_db_config);
    my $db_user = $db_config->{'db_user'};
    my $db_pass = $db_config->{'db_pass'};
    my $db_name = $db_config->{'db_name'};
    my $db_host = $db_config->{'db_host'};
    # ----------------------------------------------------------------
    # Define database conection :
    # ----------------------------------------------------------------
    my $dsn = 'DBI:Pg:database='.$db_name.';host='.$db_host.';port=5432';
    $dbh = DBI->connect($dsn, $db_user, $db_pass, {RaiseError => 1});
    # ----------------------------------------------------------------
    # Return Result :
    # ----------------------------------------------------------------
    return $dbh;
}
# End of Module for Connection PostgreSQL DatabaseModule for Connection PostgreSQL Databas
# ===========================================================================================================

# Create Module for connection SQLite :
# ------------------------------------------------------------------------
=head1 MODULE sqlite()

		Description Subroutine :
		----------------------------------------
		Subroutine untuk koneksi sqlite Database.

    Parameter Subroutine :
    ----------------------------------------
    $fieloc_db      =>  [ Berisi Lokasi file Database ]

=cut
sub sqlite {
    
    # Define parameter module :
    # ----------------------------------------------------------------
    my ($self, $fileloc_db) = @_;
    
    # EXPR
    # ----------------------------------------------------------------
    my $driver = "SQLite";
    my $dsn = "DBI:$driver:dbname=$fileloc_db";
    my $userid = "";
    my $password = "";
    my $dbh = DBI->connect($dsn, $userid, $password, { RaiseError => 1 })
        or die $DBI::errstr;
        
    # Return Result :
    # ----------------------------------------------------------------
    return $dbh;
}
# End of Create Module for connection SQLite
# ===========================================================================================================

1;
__END__
=head1 AUTHOR
    Achmad Yusri Afandi, (linuxer08@gmail.com)

=head1 COPYRIGHT AND LICENSE
    Copyright (c) 2016, Achmad Yusri Afandi, All Rights reserved.

    Pustaka yang berfungsi untuk melakukan koneksi database.
=cut