package Dancer::Serializer::Dumper;

use strict;
use warnings;
use base 'Dancer::Serializer::Abstract';
use Data::Dumper;

sub from_dumper {
    my ($string) = @_;
    my $s = Dancer::Serializer::Dumper->new;
    $s->deserialize($string);
}

sub to_dumper {
    my ($data) = @_;
    my $s = Dancer::Serializer::Dumper->new;
    $s->serialize($data);
}

sub serialize {
    my ($self, $entity) = @_;
    {
        local $Data::Dumper::Purity = 1;
        return Dumper($entity);
    }
}

sub deserialize {
    my ($self, $content) = @_;
    eval "$content";
}

sub content_type { 'text/plain' }

1;
