﻿package Carrot::Personality::Valued::Internet::Protocol::HTTP::Status_Code::Constants
# /type class
# /attribute_type ::One_Anonymous::Scalar
# /capability ""
{
	use strict;
	use warnings 'FATAL' => 'all';

	sub HTTP_STATUS_CODE_100_CONTINUE() { 100 }
	sub HTTP_STATUS_CODE_101_SWITCHING_PROTOCOLS() { 101 }
	sub HTTP_STATUS_CODE_102_PROCESSING() { 102 }

	sub HTTP_STATUS_CODE_200_OK() { 200 }
	sub HTTP_STATUS_CODE_201_CREATED() { 201 }
	sub HTTP_STATUS_CODE_202_ACCEPTED() { 202 }
	sub HTTP_STATUS_CODE_203_NON_AUTHORITATIVE_INFORMATION() { 203 }
	sub HTTP_STATUS_CODE_204_NO_CONTENT() { 204 }
	sub HTTP_STATUS_CODE_205_RESET_CONTENT() { 205 }
	sub HTTP_STATUS_CODE_206_PARTIAL_CONTENT() { 206 }
	sub HTTP_STATUS_CODE_207_MULTI_STATUS() { 207 }
	sub HTTP_STATUS_CODE_208_ALREADY_REPORTED() { 208 }
	sub HTTP_STATUS_CODE_226_IM_USED() { 226 }

	sub HTTP_STATUS_CODE_300_MULTIPLE_CHOICES() { 300 }
	sub HTTP_STATUS_CODE_301_MOVED_PERMANENTLY() { 301 }
	sub HTTP_STATUS_CODE_302_FOUND() { 302 }
	sub HTTP_STATUS_CODE_303_SEE_OTHER() { 303 }
	sub HTTP_STATUS_CODE_304_NOT_MODIFIED() { 304 }
	sub HTTP_STATUS_CODE_305_USE_PROXY() { 305 }
	sub HTTP_STATUS_CODE_306_RESERVED() { 306 }
	sub HTTP_STATUS_CODE_307_TEMPORARY_REDIRECT() { 307 }

	sub HTTP_STATUS_CODE_400_BAD_REQUEST() { 400 }
	sub HTTP_STATUS_CODE_401_UNAUTHORIZED() { 401 }
	sub HTTP_STATUS_CODE_402_PAYMENT_REQUIRED() { 402 }
	sub HTTP_STATUS_CODE_403_FORBIDDEN() { 403 }
	sub HTTP_STATUS_CODE_404_NOT_FOUND() { 404 }
	sub HTTP_STATUS_CODE_405_METHOD_NOT_ALLOWED() { 405 }
	sub HTTP_STATUS_CODE_406_NOT_ACCEPTABLE() { 406 }
	sub HTTP_STATUS_CODE_407_PROXY_AUTHENTICATION_REQUIRED() { 407 }
	sub HTTP_STATUS_CODE_408_REQUEST_TIMEOUT() { 408 }
	sub HTTP_STATUS_CODE_409_CONFLICT() { 409 }
	sub HTTP_STATUS_CODE_410_GONE() { 410 }
	sub HTTP_STATUS_CODE_411_LENGTH_REQUIRED() { 411 }
	sub HTTP_STATUS_CODE_412_PRECONDITION_FAILED() { 412 }
	sub HTTP_STATUS_CODE_413_REQUEST_ENTITY_TOO_LARGE() { 413 }
	sub HTTP_STATUS_CODE_414_REQUEST_URI_TOO_LONG() { 414 }
	sub HTTP_STATUS_CODE_415_UNSUPPORTED_MEDIA_TYPE() { 415 }
	sub HTTP_STATUS_CODE_416_REQUESTED_RANGE_NOT_SATISFIABLE() { 416 }
	sub HTTP_STATUS_CODE_417_EXPECTATION_FAILED() { 417 }
	sub HTTP_STATUS_CODE_422_UNPROCESSABLE_ENTITY() { 422 }
	sub HTTP_STATUS_CODE_423_LOCKED() { 423 }
	sub HTTP_STATUS_CODE_424_FAILED_DEPENDENCY() { 424 }
	sub HTTP_STATUS_CODE_425_RESERVED_FOR_WEBDAV_ADVANCED() { 425 }
	sub HTTP_STATUS_CODE_426_UPGRADE_REQUIRED() { 426 }

	sub HTTP_STATUS_CODE_500_INTERNAL_SERVER_ERROR() { 500 }
	sub HTTP_STATUS_CODE_501_NOT_IMPLEMENTED() { 501 }
	sub HTTP_STATUS_CODE_502_BAD_GATEWAY() { 502 }
	sub HTTP_STATUS_CODE_503_SERVICE_UNAVAILABLE() { 503 }
	sub HTTP_STATUS_CODE_504_GATEWAY_TIMEOUT() { 504 }
	sub HTTP_STATUS_CODE_505_HTTP_VERSION_NOT_SUPPORTED() { 505 }
	sub HTTP_STATUS_CODE_506_VARIANT_ALSO_NEGOTIATES() { 506 }
	sub HTTP_STATUS_CODE_507_INSUFFICIENT_STORAGE() { 507 }
	sub HTTP_STATUS_CODE_508_LOOP_DETECTED() { 508 }
	sub HTTP_STATUS_CODE_510_NOT_EXTENDED() { 510 }

# =--------------------------------------------------------------------------= #

sub provide_constants
# /type method
# /effect ""
# //parameters
# //returns
#	?
{
	my ($this) = @ARGUMENTS;

	return('HTTP_STATUS_CODE_', [qw(
		100_CONTINUE
		101_SWITCHING_PROTOCOLS
		102_PROCESSING

		200_OK
		201_CREATED
		202_ACCEPTED
		203_NON_AUTHORITATIVE_INFORMATION
		204_NO_CONTENT
		205_RESET_CONTENT
		206_PARTIAL_CONTENT
		207_MULTI_STATUS
		208_ALREADY_REPORTED
		226_IM_USED

		300_MULTIPLE_CHOICES
		301_MOVED_PERMANENTLY
		302_FOUND
		303_SEE_OTHER
		304_NOT_MODIFIED
		305_USE_PROXY
		306_RESERVED
		307_TEMPORARY_REDIRECT

		400_BAD_REQUEST
		401_UNAUTHORIZED
		402_PAYMENT_REQUIRED
		403_FORBIDDEN
		404_NOT_FOUND
		405_METHOD_NOT_ALLOWED
		406_NOT_ACCEPTABLE
		407_PROXY_AUTHENTICATION_REQUIRED
		408_REQUEST_TIMEOUT
		409_CONFLICT
		410_GONE
		411_LENGTH_REQUIRED
		412_PRECONDITION_FAILED
		413_REQUEST_ENTITY_TOO_LARGE
		414_REQUEST_URI_TOO_LONG
		415_UNSUPPORTED_MEDIA_TYPE
		416_REQUESTED_RANGE_NOT_SATISFIABLE
		417_EXPECTATION_FAILED
		422_UNPROCESSABLE_ENTITY
		423_LOCKED
		424_FAILED_DEPENDENCY
		425_RESERVED_FOR_WEBDAV_ADVANCED
		426_UPGRADE_REQUIRED

		500_INTERNAL_SERVER_ERROR
		501_NOT_IMPLEMENTED
		502_BAD_GATEWAY
		503_SERVICE_UNAVAILABLE
		504_GATEWAY_TIMEOUT
		505_HTTP_VERSION_NOT_SUPPORTED
		506_VARIANT_ALSO_NEGOTIATES
		507_INSUFFICIENT_STORAGE
		508_LOOP_DETECTED
		510_NOT_EXTENDED
	)]);
}

# =--------------------------------------------------------------------------= #

	return(PERL_FILE_LOADED);
}
# //revision_control
#	version 1.1.43
#	branch main
#	maturity alpha
# /license MPL-2.0 (Mozilla Public License v2.0)
# /copyright "(C) 2010-2014 Winfried Trümper <pub+perl@wt.tuxomania.net>"
