use strict;
use blib;
use Language::Lisp::ECLs;
my $cl = new Language::Lisp::ECLs;

my $r;
$r = $cl->eval_string("(defstruct foo
    bar fluffy
)");
print "[$r]\n";
$r = $cl->eval_string("(make-foo)");
print "[$r]\n";
$r = $cl->eval_string("(setq asdf (lambda (x) (+ 1 x)))");
print "[$r]\n";
$r = $cl->eval_string("(frustrated)");
print "[$r]\n";
__END__
$r = $cl->eval_string("(expt 2 1000)");
print "[$r]\n", "s=",$r->stringify,"\n";
$r = $cl->eval_string(<<"EOS");
(defpackage "QW")
EOS
print "[$r]\n",$r->stringify,"\n";

$r = $cl->eval_string(<<"EOS");
(defun this (a)
  (make-string a :initial-element #\\t))
EOS
print "[$r]\n",$r->stringify,"\n";

$r = $cl->eval_string(<<"EOS");
'qw::erty
EOS
print "[$r]\n",$r->stringify,"\n";

$r = $cl->eval_string(<<"EOS");
'qwerty
EOS
print "[$r]\n",$r->stringify,"\n";

$r = $cl->eval_string(<<"EOS");
(this 50)
EOS
print "[$r]\n";# n/a,$r->stringify,"\n";

