#!perl

# t/error-logger.t #

#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Role-ErrorLogger.
#
#   perl-Dist-Zilla-Role-ErrorLogger is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Role-ErrorLogger is distributed in the hope that it will be useful, but WITHOUT
#   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Role-ErrorLogger. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use strict;
use warnings;
use autodie ':all';

use Test::DZil;
use Test::Fatal;
use Test::More;

use lib 't/lib';    # Make ErrorLoggerTestPlugin accessible.

our $Test;

plan tests => 2;

subtest success => sub {
    plan tests => 8;
    my $tzil = Builder->from_config( { dist_root => 't/dist' } );
    local $Test = sub {
        my ( $self ) = @_;
        my $rc;
        is( $self->error_count, 0, 'error count inited' );
        $self->abort_if_error();
        pass( 'not yet aborted' );
        $rc = $self->log_error( 'the first error' );
        ok( $rc, 'log_error returns true value' );
        is( $self->error_count, 1, 'error count bumped' );
        $rc = $self->log_error( 'another error' );
        ok( $rc, 'log_error returns true value again' );
        is( $self->error_count, 2, 'error count bumped again' );
    };
    is( exception { $tzil->build }, undef, 'build must be successful' );
    my @messages = map( $_->{ message }, @{ $tzil->chrome->logger->events } );
    is_deeply(
        [ grep( $_ =~ m{^\[ErrorLoggerTestPlugin\]\s}, @messages ) ],
        [ '[ErrorLoggerTestPlugin] the first error', '[ErrorLoggerTestPlugin] another error' ],
        'error messages are in place'
    );
    done_testing();
};

subtest failure => sub {
    plan tests => 3;
    my $tzil = Builder->from_config( { dist_root => 't/dist' } );
    $Test = sub {
        my ( $self ) = @_;
        $self->abort_if_error();
        pass( 'not yet aborted' );
        $self->log_error( 'error' );
        $self->abort_if_error();
        fail( 'must be aborted before this point' );
    };
    like(
        exception { $tzil->build; },
        qr{^\[ErrorLoggerTestPlugin\] 1 errors?, aborting\.\.\.},
        'build must fail'
    );
    my @messages = map( $_->{ message }, @{ $tzil->chrome->logger->events } );
    is_deeply(
        [ grep( $_ =~ m{^\[ErrorLoggerTestPlugin\]\s}, @messages ) ],
        [ '[ErrorLoggerTestPlugin] error', '[ErrorLoggerTestPlugin] 1 errors, aborting...' ],
        'error messages are in place'
    );
    done_testing();
};

done_testing();

exit( 0 );

# end of file #
