#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/ManifestReadTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Read.
#
#   perl-Dist-Zilla-Plugin-Manifest-Read is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Read is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Read. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package ManifestReadTester;

use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'Test::Dist::Zilla::Build';

use Test::More;
use Test::Deep qw{ cmp_deeply };
use Perl::Version;
use Path::Tiny;

has manifest => (
    isa         => 'Str',
    is          => 'ro',
);

sub _build_plugins {
    my ( $self ) = @_;
    return [
        [ 'Manifest::Read' => {
            defined( $self->manifest ) ? (
                manifest => $self->manifest
            ) : (
            ),
        } ],
    ];
};

sub _build_message_filter {
    my ( $self ) = @_;
    return sub {
        map( { ( my $r = $_ ) =~ s{^\[[^\]]*\] }{}; $r } grep( $_ =~ m{^\Q[Manifest::Read]\E }, @_ ) );
    };
};

test 'Files' => sub {
    my ( $self ) = @_;
    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    };
    my $files = $self->expected->{ files };
    my @names = keys( %$files );
    my $built_in = path( $self->tzil->built_in );
    plan 'no_plan';
    for my $name ( @names ) {
        my $file = $built_in->child( $name );
        if ( defined( $files->{ $name } ) ) {
            ok( $file->exists, "$name exists" ) and do {
                my $bulk = ref( $files->{ $name } ) ? (
                    [ $file->lines_utf8( { chomp => 1 } ) ]
                ) : (
                    $file->slurp_utf8()
                );
                cmp_deeply( $bulk, $files->{ $name }, "$name content" );
            };
        } else {
            ok( ! $file->exists, "$name not exist" );
        };
    };
};

1;

# end of file #
