use strict;
use ExtUtils::MakeMaker;
use ExtUtils::PkgConfig;

# minimum required version of dependencies we need to build
our %build_reqs = (
	'rpm' => '4.11.0',
);
our %CONFIGURE_REQUIRES = (
	'ExtUtils::Depends'   => '0.300',
	'ExtUtils::MakeMaker' => '6.64',
	'ExtUtils::PkgConfig' => '1.00', # for finding rpm-devel
);
my $is_debian = -f '/etc/debian_version';

# Writing a fake Makefile ensures that CPAN will pick up the correct
# dependencies and install them.
unless (eval "use ExtUtils::Depends '$CONFIGURE_REQUIRES{'ExtUtils::Depends'}';"
           . "use ExtUtils::PkgConfig '$CONFIGURE_REQUIRES{'ExtUtils::PkgConfig'}';"
           . "1") {
   warn "$@\n";
   WriteMakefile(
         NAME         => 'URPM',
         PREREQ_FATAL => 1,
         PREREQ_PM    => \%CONFIGURE_REQUIRES,
   );
   exit 1; # not reached
}

my %cfg;
unless (eval { %cfg = ExtUtils::PkgConfig->find("rpm >= $build_reqs{rpm}"); 1 })
{
	my $rpmdev_pkg   = $is_debian ? "librpm-dev" : "rpm-devel";
	warn "*** Ensure that $rpmdev_pkg is installed\n" . $@;
	exit 0;
}
my @rpm_version = split /\./, $cfg{modversion};
open(my $FH, "> rpmversion.h") or die "Can't open rpmversion.h";
print $FH "/* File generated by Makefile.PL\n";
print $FH " */\n\n";
print $FH "#ifndef RPMVERSION_H\n#define RPMVERSION_H\n\n";
foreach (qw(
    4.11.0
    4.12.0
    4.13.0
    4.14.0
    4.14.2
    )) {
    my $v = $_;
    $cfg{modversion} < $v and last;
    $v =~ s/\./_/g;
    print $FH "#define RPM$v\n";
}
print $FH "\n#endif\n";
close($FH);

my $workaround;
if (-e '/etc/redhat-release' && $cfg{modversion} =~ /4.11/) {
   $workaround = '-DPATCHED_RH';
}
my $ccflags = join(' ', '-Wall -Wextra -fno-strict-aliasing', $cfg{cflags}, "-DRPM_VERSON=$cfg{modversion}", $workaround);

print "Found RPM version $cfg{modversion} (compiling with flags: $ccflags)\n";

WriteMakefile(
    NAME	=> 'URPM',
    ABSTRACT_FROM => 'URPM.pm',
    AUTHOR	=> 'Thierry Vignaud',
    LICENSE     => 'perl_5',
    CONFIGURE_REQUIRES => \%CONFIGURE_REQUIRES,
    PREREQ_PM	=> {
	'MDV::Packdrakeng' => '1.00', # for URPM::Build
    },
    'TEST_REQUIRES' => {
	'Test::Pod' => '1.00',
    },
    META_MERGE => {
	'meta-spec' => { version => 2 },
	# For proper CPAN indexation:
	provides => {
	    'URPM' => {
		file => 'URPM.pm',
		version => 'v5.23.2.5',
	    },
	    'URPM::Resolve' => {
		file => 'URPM/Resolve.pm',
	    },
	},
        resources => {
            repository  => {
		type => 'git',
		url => 'git://git.mageia.org/software/rpm/perl-URPM/',
		web =>  'http://gitweb.mageia.org/software/rpm/perl-URPM/',
	    },
        },
	release_status => 'stable'
    },
    MIN_PERL_VERSION => '5.008001',
    CCFLAGS	=> $ccflags,
    VERSION_FROM	=> 'URPM.pm',
    LIBS	=> [ $cfg{libs} . ' -lrpmbuild' ],
    dist	=> { COMPRESS => "xz -f", SUFFIX => ".xz" },
    realclean	=> { FILES => "t/RPMS/noarch/*" },
);
